/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.planning.mokos;

import com.google.common.collect.Lists;
import cz.insophy.inplan.plan.WorkplaceActivity;
import cz.insophy.inplan.planning.ActivityChange;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;

public class PositioningResult {
    private final List<ActivityChange> activityChanges = Lists.newArrayList();
    private boolean ok = true;
    private long nextPossibleTime = Long.MAX_VALUE;

    protected PositioningResult() {
    }

    protected WorkplaceActivity popActivity() {
        WorkplaceActivity res = null;
        int idx = this.activityChanges.size() - 1;
        if (idx >= 0) {
            res = (WorkplaceActivity)this.activityChanges.remove(idx).getActivity();
        }
        return res;
    }

    protected WorkplaceActivity peekActivity() {
        WorkplaceActivity res = null;
        int idx = this.activityChanges.size() - 1;
        if (idx >= 0) {
            res = (WorkplaceActivity)this.activityChanges.get(idx).getActivity();
        }
        return res;
    }

    protected void setNextPossibleTime(long nextPossibleTime) {
        this.nextPossibleTime = nextPossibleTime;
    }

    protected void addActivity(WorkplaceActivity wa) {
        this.activityChanges.add(new ActivityChange(wa, ActivityChange.ChangeType.ADDED));
    }

    protected void removeActivity(WorkplaceActivity wa) {
        this.activityChanges.add(new ActivityChange(wa, ActivityChange.ChangeType.REMOVED));
    }

    protected void setNok() {
        this.ok = false;
        this.activityChanges.clear();
    }

    public List<ActivityChange> getActivityChanges() {
        return this.activityChanges;
    }

    public boolean isOk() {
        return this.ok;
    }

    public long getNextPossibleTime() {
        return this.nextPossibleTime;
    }

    public void addActivityChanges(Collection<ActivityChange> actChanges) {
        this.activityChanges.addAll(actChanges);
    }

    public void optimizeChanges() {
        if (this.isOk()) {
            ActivityChange lastChange = null;
            ListIterator<ActivityChange> iter = this.activityChanges.listIterator();
            while (iter.hasNext()) {
                ActivityChange change = iter.next();
                if (lastChange != null && lastChange.getActivity() == change.getActivity() && lastChange.getChangeType() != change.getChangeType()) {
                    iter.remove();
                    iter.previous();
                    iter.remove();
                    lastChange = null;
                    continue;
                }
                lastChange = change;
            }
        }
    }

    public String toString() {
        return String.format("%s(%s)", this.getClass().getSimpleName(), this.activityChanges);
    }
}

